package com.androidsmile.labbluetooth;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.SeekBar;
import java.math.BigInteger;
import app.akexorcist.bluetotohspp.library.BluetoothSPP;
import app.akexorcist.bluetotohspp.library.BluetoothState;
import app.akexorcist.bluetotohspp.library.DeviceList;


public class MainActivity extends AppCompatActivity {

  // int temp;
   int temp2;
   int kol;
   String[] arr;
   final String ON1 = "101";
   final String OFF1 = "102";

    BluetoothSPP bluetooth;
    TextView txtArduino;
    TextView textView7;
    TextView textView9;
    TextView textView;
    Button connect;
    Button on1;
    Button off1;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        bluetooth = new BluetoothSPP(this);
        connect = (Button) findViewById(R.id.connect);
        txtArduino = (TextView) findViewById(R.id.txtArduino);
        textView7 = (TextView) findViewById(R.id.textView7);
        textView9 = (TextView) findViewById(R.id.textView9);
        textView = (TextView) findViewById(R.id.textView);
        on1 = (Button) findViewById(R.id.on1);
        off1 = (Button) findViewById(R.id.off1);

        if (!bluetooth.isBluetoothAvailable()) {
            Toast.makeText(getApplicationContext(), "Bluetooth не доступен", Toast.LENGTH_SHORT).show();
            finish();
        }

        bluetooth.setBluetoothConnectionListener(new BluetoothSPP.BluetoothConnectionListener() {
            public void onDeviceConnected(String name, String address) {
                connect.setText("Подключен " + name);
            }

            public void onDeviceDisconnected() {
                connect.setText("Связь потеряна");
            }

            public void onDeviceConnectionFailed() {
                connect.setText("Не удается подключиться");
            }
        });

        connect.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (bluetooth.getServiceState() == BluetoothState.STATE_CONNECTED) {
                    bluetooth.disconnect();
                } else {
                    Intent intent = new Intent(getApplicationContext(), DeviceList.class);
                    startActivityForResult(intent, BluetoothState.REQUEST_CONNECT_DEVICE);
                }
            }
        });

////////////////////////// прием данных с порта ................!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        bluetooth.setOnDataReceivedListener(new BluetoothSPP.OnDataReceivedListener() {
            public void onDataReceived(byte[] data, String message) {
              //  Toast.makeText(getApplicationContext(), String.format("Data Received: %s", message),
                 //       Toast.LENGTH_SHORT).show();
                kol = message.length();// длина string
                if(kol>4) {
                    arr = message.split(":");// разбивка string
                    temp2 = Integer.parseInt(arr[1].trim());// string to int
                    txtArduino.setText(arr[0] + "\u00B0C");
                    textView.setText(temp2 + "\u00B0C");
                }
            } });



        //////////////////// 1  ////////////////////////////////////
        on1.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                bluetooth.send(ON1, true);

            }
        });

        off1.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                bluetooth.send(OFF1, true);

            }
        });


    }/// onCreate

    public void onStart() {
        super.onStart();
        if (!bluetooth.isBluetoothEnabled()) {
            bluetooth.enable();
        } else {
            if (!bluetooth.isServiceAvailable()) {
                bluetooth.setupService();
                bluetooth.startService(BluetoothState.DEVICE_OTHER);
            }
        }
    }


    public void onDestroy() {
        super.onDestroy();
        bluetooth.stopService();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == BluetoothState.REQUEST_CONNECT_DEVICE) {
            if (resultCode == Activity.RESULT_OK)
                bluetooth.connect(data);
        } else if (requestCode == BluetoothState.REQUEST_ENABLE_BT) {
            if (resultCode == Activity.RESULT_OK) {
                bluetooth.setupService();
            } else {
                Toast.makeText(getApplicationContext()
                        , "Bluetooth не был включен"
                        , Toast.LENGTH_SHORT).show();
                finish();
            }
        }
    }



}

